/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wancommoninterfaceconfig;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.OnlineMonitorInfo;
import de.avm.android.tr064.model.UnsignedNumber;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetOnlineMonitor extends WanCommonIfaceConfigSoapHelper<OnlineMonitorInfo>
{
	private long mSyncGroupIndex;
	
	/**
	 * Gets online monitor info
	 * 
	 * @throws IllegalArgumentException
	 * 		illegal value of syncGroupIndex 
	 */
	public GetOnlineMonitor(ISoapCredentials soapCredentials, long syncGroupIndex)
	{
		super(soapCredentials);
		UnsignedNumber.validateUi4(syncGroupIndex, "syncGroupIndex");
		mSyncGroupIndex = syncGroupIndex;
	}

    public long getIndex()
    {
        return mSyncGroupIndex;
    }

    /**
     * @throws IllegalArgumentException
     * 		illegal value of syncGroupIndex
     */
    public GetOnlineMonitor setIndex(long syncGroupIndex)
    {
        UnsignedNumber.validateUi4(syncGroupIndex, "syncGroupIndex");
        mSyncGroupIndex = syncGroupIndex;
        return this;
    }

	@Override
	public OnlineMonitorInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();

		OnlineMonitorInfo result = new OnlineMonitorInfo(mSyncGroupIndex);
		result.setTotalNumberSyncGroups(getLongByName("NewTotalNumberSyncGroups", input));
		result.setSyncGroupName(getValueByName("NewSyncGroupName", input));
		result.setSyncGroupMode(getValueByName("NewSyncGroupMode", input));
		result.setMaxDS(getLongByName("Newmax_ds", input));
		result.setMaxUS(getLongByName("Newmax_us", input));
		result.setCurrentBpsDS(getValueByName("Newds_current_bps", input));
		result.setCurrentBpsMC(getValueByName("Newmc_current_bps", input));
		result.setCurrentBpsUS(getValueByName("Newus_current_bps", input));
		result.setPrioRealtimeBps(getValueByName("Newprio_realtime_bps", input));
		result.setPrioHighBps(getValueByName("Newprio_high_bps", input));
		result.setPrioDefaultBps(getValueByName("Newprio_default_bps", input));
		result.setPrioLowBps(getValueByName("Newprio_low_bps", input));

		return result;
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewSyncGroupIndex>" + Long.toString(mSyncGroupIndex) + "</NewSyncGroupIndex>";
	}

	@Override
	public String getSoapMethod()
	{
		return "X_AVM-DE_GetOnlineMonitor";
	}
}
