/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information on User Interface as received from the Fritzbox 
 */
public class UserInterfaceInfo implements Parcelable
{
	/*
	 * NewUpgradeAvailable	Out	Boolean
	 * NewPasswordRequired	Out	Boolean
	 * NewPasswordUserSelectable	Out	Boolean
	 * NewWarrantyDate	Out	DateTime
	 * NewX_AVM-DE_Version	Out	String
	 * NewX_AVM-DE_DownloadURL	Out	String
	 * NewX_AVM-DE_InfoURL	Out	String
	 * NewX_AVM-DE_UpdateState	Out	String
	 * NewX_AVM-DE_LaborVersion	Out	String
	*/

	private boolean mUpgradeAvailable = false;
	private boolean mPasswordRequired = false;
	private boolean mPasswordUserSelectable = false;
	private long mWarrantyDate = 0;
	private String mVersion;
	private String mDownloadURL;
	private String mInfoURL;
	private String mUpdateState;
	private String mLaborVersion;

	public boolean isUpgradeAvailable()
	{
		return mUpgradeAvailable;
	}
	
	public void setUpgradeAvailable(boolean value)
	{
		mUpgradeAvailable = value;
	}

	public boolean isPasswordRequired()
	{
		return mPasswordRequired;
	}
	
	public void setPasswordRequired(boolean value)
	{
		mPasswordRequired = value;
	}

	public boolean isPasswordUserSelectable()
	{
		return mPasswordUserSelectable;
	}
	
	public void setPasswordUserSelectable(boolean value)
	{
		mPasswordUserSelectable = value;
	}
	
	public long getWarrantyDate()
	{
		return mWarrantyDate;
	}
	
	public void setWarrantyDate(long value)
	{
		mWarrantyDate = value;
	}
	
	public String getVersion()
	{
		return mVersion;
	}
	
	public void setVersion(String value)
	{
		mVersion = value;
	}
	
	public String getDownloadURL()
	{
		return mDownloadURL;
	}
	
	public void setDownloadURL(String value)
	{
		mDownloadURL = value;
	}
	
	public String getInfoURL()
	{
		return mInfoURL;
	}
	
	public void setInfoURL(String value)
	{
		mInfoURL = value;
	}
	
	public String getUpdateState()
	{
		return mUpdateState;
	}
	
	public void setUpdateState(String value)
	{
		mUpdateState = value;
	}
	
	public String getLaborVersion()
	{
		return mLaborVersion;
	}
	
	public void setLaborVersion(String value)
	{
		mLaborVersion = value;
	}

	public UserInterfaceInfo()
	{
	}

	public UserInterfaceInfo(Parcel in)
	{
		mUpgradeAvailable = in.readInt() != 0;
		mPasswordRequired = in.readInt() != 0;
		mPasswordUserSelectable = in.readInt() != 0;
		mWarrantyDate = in.readLong();
		mVersion = in.readString();
		mDownloadURL = in.readString();
		mInfoURL = in.readString();
		mUpdateState = in.readString();
		mLaborVersion = in.readString();
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<UserInterfaceInfo> CREATOR =
			new Parcelable.Creator<UserInterfaceInfo>()
	{
		public UserInterfaceInfo createFromParcel(Parcel in)
		{
			return new UserInterfaceInfo(in);
		}

		public UserInterfaceInfo[] newArray(int size)
		{
			return new UserInterfaceInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeInt((mUpgradeAvailable) ? 1 : 0);
		out.writeInt((mPasswordRequired) ? 1 : 0);
		out.writeInt((mPasswordUserSelectable) ? 1 : 0);
		out.writeLong(mWarrantyDate);
		out.writeString(mVersion);
		out.writeString(mDownloadURL);
		out.writeString(mInfoURL);
		out.writeString(mUpdateState);
		out.writeString(mLaborVersion);
	}
}