/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.gui;

import de.avm.android.fritzapp.R;
import de.avm.android.fritzapp.com.ComSettingsChecker;
import de.avm.android.fritzapp.com.discovery.BoxInfo;
import android.content.Context;
import android.preference.CheckBoxPreference;
import android.text.TextUtils;

public class FritzboxListItem extends CheckBoxPreference
{
	public static final String BUNDLE_UDN = "udn";
	private BoxInfo mInfo;

	public String getUdn()
	{
		if (mInfo != null) return mInfo.getUdn();
		return "";
	}

	public boolean isTr64Device()
	{
		if (mInfo != null) return mInfo.isTr64();
		return false;
	}
	
	public FritzboxListItem(Context context, BoxInfo info)
	{
		super(context);

		mInfo = info;
		setPersistent(false);
		updateInfo();
	}
	
	public void setChecked(boolean checked)
	{
		if (isChecked() != checked)
		{
			super.setChecked(checked);
			updateInfo();
		}
	}
	
	public void updateInfo()
	{
		setWidgetLayoutResource(mInfo.isAvailable() ?
				R.layout.preference_widget_radio : 0);

		setTitle(mInfo.getDisplayName());
		String summary = mInfo.getDisplayDescription();
		if (!TextUtils.isEmpty(summary)) summary += "\n";
		
		if (isChecked())
		{
			// show if currently connected
			BoxInfo boxInfo = ComSettingsChecker.getBoxInfo();
			int resId = ((boxInfo != null) && boxInfo.getUdn().equals(mInfo.getUdn())) ?
					R.string.pref_address_connected :
					R.string.pref_address_notconnected;
			summary += getContext().getString(resId);
		}
		else if (mInfo.hasPreferences())
		{
			// we have settings for this box
			summary += getContext().getString(R.string.pref_address_known);
		}
		
		setSummary(summary);
	}
}
